%This function receives the image and the coordinates of the localized
%model and returns the three images containing CA1, CA3 and DG

function [ca1im ca3im dgim] = simpleSegmentation(im, modeldg, modelca, modeldgout, modelcaout)

    %for CA model I consider the segment between points 2 e 4 (CA1) and 
    %the one between 6 e 7 (CA3)

    caWidth = (modelca(7,1) - modelcaout(7,1))*1.6; %engineering factor: increase this to increase area

    ca1segm = modelca(3,:) - modelca(2,:);
    [ca1segm(1) ca1segm(2)] = cart2pol(ca1segm(1),ca1segm(2));
    [ca1shift(1) ca1shift(2)]= pol2cart(ca1segm(1) + pi/2,caWidth);
    ca1mask = zeros(4,2);
    ca1mask(1,:) = [modelca(2,1)+ca1shift(1) modelca(2,2)+ca1shift(2)];
    ca1mask(2,:) = [modelca(3,1)+ca1shift(1) modelca(3,2)+ca1shift(2)];
    ca1mask(3,:) = [modelca(3,1)-ca1shift(1) modelca(3,2)-ca1shift(2)];
    ca1mask(4,:) = [modelca(2,1)-ca1shift(1) modelca(2,2)-ca1shift(2)];
    ca2segm = modelca(4,:) - modelca(3,:);
    [ca2segm(1) ca2segm(2)] = cart2pol(ca2segm(1),ca2segm(2));
    [ca2shift(1) ca2shift(2)]= pol2cart(ca2segm(1) + pi/2,caWidth);
    ca2mask = zeros(4,2);
    ca2mask(1,:) = [modelca(3,1)+ca2shift(1) modelca(3,2)+ca2shift(2)];
    ca2mask(2,:) = [modelca(4,1)+ca2shift(1) modelca(4,2)+ca2shift(2)];
    ca2mask(3,:) = [modelca(4,1)-ca2shift(1) modelca(4,2)-ca2shift(2)];
    ca2mask(4,:) = [modelca(3,1)-ca2shift(1) modelca(3,2)-ca2shift(2)];

    ca1mask = [ca1mask ; ca2mask];
    ca1im = imcrop(im,[min(ca1mask(:,1)) min(ca1mask(:,2)) max(ca1mask(:,1))-min(ca1mask(:,1)) max(ca1mask(:,2))-min(ca1mask(:,2))]);

    ca3segm = modelca(7,:) - modelca(6,:);
    [ca3segm(1) ca3segm(2)] = cart2pol(ca3segm(1),ca3segm(2));
    [ca3shift(1) ca3shift(2)]= pol2cart(ca3segm(1) + pi/2,caWidth);
    ca3mask = zeros(4,2);
    ca3mask(1,:) = [modelca(6,1)+ca3shift(1) modelca(6,2)+ca3shift(2)];
    ca3mask(2,:) = [modelca(7,1)+ca3shift(1) modelca(7,2)+ca3shift(2)];
    ca3mask(3,:) = [modelca(7,1)-ca3shift(1) modelca(7,2)-ca3shift(2)];
    ca3mask(4,:) = [modelca(6,1)-ca3shift(1) modelca(6,2)-ca3shift(2)];

    ca3im = imcrop(im,[min(ca3mask(:,1)) min(ca3mask(:,2)) max(ca3mask(:,1))-min(ca3mask(:,1)) max(ca3mask(:,2))-min(ca3mask(:,2))]);

    %for DG model, I consider segments 2-3, 3-4 e 5-6.
    dgWidth = (modeldgout(7,2) - modeldg(7,2))*1.6; %engineering factor: increase this to increase area

    dg1segm = modeldg(6,:) - modeldg(5,:);
    [dg1segm(1) dg1segm(2)] = cart2pol(dg1segm(1),dg1segm(2));
    [dg1shift(1) dg1shift(2)]= pol2cart(dg1segm(1) + pi/2,dgWidth);
    dg1mask = zeros(4,2);
    dg1mask(1,:) = [modeldg(5,1)+dg1shift(1) modeldg(5,2)+dg1shift(2)];
    dg1mask(2,:) = [modeldg(6,1)+dg1shift(1) modeldg(6,2)+dg1shift(2)];
    dg1mask(3,:) = [modeldg(6,1)-dg1shift(1) modeldg(6,2)-dg1shift(2)];
    dg1mask(4,:) = [modeldg(5,1)-dg1shift(1) modeldg(5,2)-dg1shift(2)];

    dg2segm = modeldg(3,:) - modeldg(2,:);
    [dg2segm(1) dg2segm(2)] = cart2pol(dg2segm(1),dg2segm(2));
    [dg2shift(1) dg2shift(2)]= pol2cart(dg2segm(1) + pi/2,dgWidth);
    dg2mask = zeros(4,2);
    dg2mask(1,:) = [modeldg(2,1)+dg2shift(1) modeldg(2,2)+dg2shift(2)];
    dg2mask(2,:) = [modeldg(3,1)+dg2shift(1) modeldg(3,2)+dg2shift(2)];
    dg2mask(3,:) = [modeldg(3,1)-dg2shift(1) modeldg(3,2)-dg2shift(2)];
    dg2mask(4,:) = [modeldg(2,1)-dg2shift(1) modeldg(2,2)-dg2shift(2)];

    dg3segm = modeldg(4,:) - modeldg(3,:);
    [dg3segm(1) dg3segm(2)] = cart2pol(dg3segm(1),dg3segm(2));
    [dg3shift(1) dg3shift(2)]= pol2cart(dg3segm(1) + pi/2,dgWidth);
    dg3mask = zeros(4,2);
    dg3mask(1,:) = [modeldg(3,1)+dg3shift(1) modeldg(3,2)+dg3shift(2)];
    dg3mask(2,:) = [modeldg(4,1)+dg3shift(1) modeldg(4,2)+dg3shift(2)];
    dg3mask(3,:) = [modeldg(4,1)-dg3shift(1) modeldg(4,2)-dg3shift(2)];
    dg3mask(4,:) = [modeldg(3,1)-dg3shift(1) modeldg(3,2)-dg3shift(2)];

    dgmask = [dg1mask ; dg2mask ; dg3mask];
    dgim = imcrop(im,[min(dgmask(:,1)) min(dgmask(:,2)) max(dgmask(:,1))-min(dgmask(:,1)) max(dgmask(:,2))-min(dgmask(:,2))]);

    
end